/***************************************************************************
These C++ classes are copyright 1990, by William Herrera.
All those who put this code or its derivatives in a commercial product MUST
mention this copyright in their documentation for users of the products in
which this code or its derivative classes are used.  Otherwise, this code
may be freely distributed and freely used for any purpose.

Enhancements: 1991 by David Orme
	*  General cleanup.
			- I/O now takes advantage of C++ overloading.
			- Serial port I/O functionality now only in Serial class.
			- Modem functionality now only in Modem class.
	*  Possible to easily implement file Xfr prots now.
	*  CCITT CRC-16 class added							-- 2-20-1991
	*  BIOS Timer class added								-- 2-22-1991
	*  Optional timeout on all input routines added	-- 2-25-1991

***************************************************************************/

#include        <stdio.h>
#include        <conio.h>
#include        <string.h>
#include        <stdlib.h>
#include        <dos.h>

#include        "modem.hpp"

static const int defaultspeed = 2400;
// change to suit if your modem cannot do 2400 bps!

int xgetch(void)
{
   // ibm pc keyboard extended getch().
   int ch;
   return ( (ch = getch()) != 0 ) ? ch : getch() + 256;
}


int main()
{
   char dialstr[256];
	int port=1;						// change this to suit your config
	int speed=defaultspeed;

	modem m(port, speed, NOPAR, 1, 8, false);
	m.RaiseDTR();

	printf("Current baud rate is %d\n", m.GetSpeed());
	printf("Alt-B set baud rate, Alt-S shell, Alt-X exit\n");
	while (1)
	{
		int c;
		char ch;
		if (kbhit())
		{
			c = xgetch();
			if(c == 301)      // Alt-X to exit
				break;      // break out of while(1) loop.
			char st[212];
			switch(c)
			{
				case 304:      // Alt-B to set baud rate
					printf("\nCurrent baud rate is %d\n",
						m.GetSpeed());
					printf("New baud rate (300-19200): ");
					if(scanf("%7s", st) == 1)
					{
						int s = atoi(st);
						if(s > 299 && s < 19201)
							m.SetSpeed(s);
					}
					break;
				case 287:      // Alt-S to shell
					printf("\nExternal DOS command: ");
					if(scanf("%211s", st) == 1)
						system(st);
					printf("\nExiting DOS shell . . . You may continue.\n");
					break;
				default:
					m.Send(char(c));  // avoid sending (int) c
					break;
			}  // switch(c)
		}  // if kbhit()
		if ((m.Receive(ch)) != -1)
			putchar(ch);
	}  // while(1)


	// Finished.  Clean up line before exiting to prevent lockups.
	m.DropDTR();
	m.Pause();
	return 0;
}

