/***************************************************************************
These C++ classes are copyright 1990, by William Herrera.
All those who put this code or its derivatives in a commercial product MUST
mention this copyright in their documentation for users of the products in
which this code or its derivative classes are used.  Otherwise, this code
may be freely distributed and freely used for any purpose.

Enhancements: 1991 by David Orme
	*  General cleanup.
			- I/O now takes advantage of C++ overloading.
			- Serial port I/O functionality now only in Serial class.
			- Modem functionality now only in Modem class.
	*  Possible to easily implement file Xfr prots now.
	*  CCITT CRC-16 class added							-- 2-20-1991
	*  BIOS Timer class added								-- 2-22-1991
	*  Optional timeout on all input routines added	-- 2-25-1991

***************************************************************************/

// file modem.cpp class definitions for modem class.

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "modem.hpp"

const char inits[] = "AT &Q0 &Q3 M1 S7=60 S11=55 V1 S0=6";
const char tonedials[] = "ATDT";
const char pulsedials[] = "ATDP";
const char answers[] = "ATA";
const char hangups[] = "ATH0";
const char resets[] = "ATZ";
const char retrns[] = "\r\n";
const char escapes[] = "+++";	
const char defaultcfgs[] = "modem.cfg";

modem::modem(int portnum, int speed, parity_t p,
						 int sbits, int dbits, boolean trans)
 : SerialPort(portnum, speed, p, sbits, dbits, trans)
{
	init = strdup(inits);
	tonedial = strdup(tonedials);
	pulsedial = strdup(pulsedials);
	answer = strdup(answers);
	hangup = strdup(hangups);
	reset = strdup(resets);
	retrn = strdup(retrns);
	escape = strdup(escapes);
}

modem::~modem()
{
	free(init);
	free(tonedial);
	free(pulsedial);
	free(answer);
	free(hangup);
	free(reset);
	free(retrn);
	free(escape);
}

void modem::ConfigureFromFile(const char * pathname)
{
	char ini[129], ton[129], pul[129], ans[129], han[129];
	char res[129], ret[129], esc[129], actualret[129];
	FILE * cfg = fopen(pathname, "r");
	if(cfg == NULL)
		fprintf(stderr, "modem error:  cannot open or use"
						" config file %s\n",	pathname);
	int n = fscanf(cfg, "%128[^\n]\n%128[^\n]\n%128[^\n]"
						"%128[^\n]\n%128[^\n]\n%128[^\n]"
						"%128[^\n]%128[^\n]",
						ini, ton, pul, ans, han, res, ret, esc);
	if(n != 8)
		fprintf(stderr, "Error in configuration file %s\n", pathname);
	else
	{
		char * p = ret;
		char * q = actualret;
		do 
		{
			if(*p == '\\')
			{
				++p;
				switch(*p)
				{
					case 'r': *p = '\r'; break;
					case 'n': *p = '\n'; break;
					case 't': *p = '\t'; break;
					case 'f': *p = '\f'; break;
					case 'v': *p = '\v'; break;
					case 'a': *p = '\a'; break;
					default: break;
				}
			}
			*q++ = *p;
		} while (*p++);
		free(init);
		free(tonedial);
		free(pulsedial);
		free(answer);
		free(hangup);
		free(reset);
		free(retrn);
		free(escape);

		init = strdup(ini);
		tonedial = strdup(ton);
		pulsedial = strdup(pul);
		answer = strdup(ans);
		hangup = strdup(han);
		reset = strdup(res);
		retrn = strdup(actualret);
		escape = strdup(esc);

		Initialize();
	}
	return;
}

void modem::Dial(char * number, boolean tone)
{
	Send( (tone) ? tonedial : pulsedial);
	Send(number);
	Send(retrn);
}

void modem::Initialize()
{
	Send(init);
	Send(retrn);
}

void modem::Answer()
{
	Send(answer);
	Send(retrn);
}

void modem::Escape()
{
	Send(escape);
	Pause(3000);
}

void modem::HangUp()
{
	Send(hangup);
	Send(retrn);
}

void modem::SendCommand(char * command)
{
	Send(command);
	Send(retrn);
}


// end of file modem.cpp

